// Type definitions for D3JS d3 standard bundle 5.16
// Project: https://github.com/d3/d3, https://d3js.org
// Definitions by: Tom Wanzek <https://github.com/tomwanzek>
//                 Alex Ford <https://github.com/gustavderdrache>
//                 Boris Yankov <https://github.com/borisyankov>
//                 denisname <https://github.com/denisname>
//                 Nathan Bierema <https://github.com/Methuselah96>
// Definitions: https://github.com/DefinitelyTyped/DefinitelyTyped
// TypeScript Version: 2.3

// Last module patch version validated against: 5.16.0

// NOTE TO MAINTAINERS: Review D3 v4.x module dependencies (see v4 sub-folder) and update its path-mappings in tsconfig (v4 folder),
// if new MAJOR version of D3 v4 modules are released!!!

export as namespace d3;

/**
 * Version number in format _Major.Minor.BugFix_, like 5.0.0.
 */
export const version: string;

export * from 'd3-array';
export * from 'd3-axis';
export * from 'd3-brush';
export * from 'd3-chord';
export * from 'd3-collection';
export * from 'd3-color';
export * from 'd3-contour';
export * from 'd3-dispatch';
export * from 'd3-drag';
export * from 'd3-dsv';
export * from 'd3-ease';
export * from 'd3-fetch';
export * from 'd3-force';
export * from 'd3-format';
export * from 'd3-geo';
export * from 'd3-hierarchy';
export * from 'd3-interpolate';
export * from 'd3-path';
export * from 'd3-polygon';
export * from 'd3-quadtree';
export * from 'd3-random';
export * from 'd3-scale';
export * from 'd3-scale-chromatic';
export * from 'd3-selection';
export * from 'd3-shape';
export * from 'd3-time';
export * from 'd3-time-format';
export * from 'd3-timer';
export * from 'd3-transition';
export * from 'd3-voronoi';
export * from 'd3-zoom';
